// leanModal v1.1 by Ray Stone - http://finelysliced.com.au
// Dual licensed under the MIT and GPL
(function ($) {
    $.fn.extend({
        leanModal: function (options) {
            var defaults = {top: 100, overlay: 0.5, closeButton: null, width: 300, maxWidth: 0};
            var overlay = $("<div id='lean_overlay'></div>");
            $("body").append(overlay);
            options = $.extend(defaults, options);
            return this.each(function () {
                var o = options;
                $(this).click(function (e) {
                    var modal_id = $(this).attr("href");
                    $("#lean_overlay").click(function () {
                        close_modal(modal_id)
                    });
                    $(o.closeButton).click(function () {
                        close_modal(modal_id)
                    });
                    var modal_height = $(modal_id).outerHeight();
                    var modal_width = $(modal_id).width();
                    $("#lean_overlay").css({display: "block", opacity: 0});
                    $("#lean_overlay").fadeTo(200, o.overlay);
                    if (o.width.indexOf("%")) {
                        var percent = o.width.replace("%", "");
                        modal_width = $(window).width() * (percent / 100);
                        if (o.maxWidth > 0 && modal_width > o.maxWidth) {
                            modal_width = o.maxWidth
                        }
                    } else {
                        modal_width = o.width
                    }
                    if (o.maxWidth == 0) {
                        o.maxWidth = o.width
                    }
                    $(modal_id).css({
                        display: "block",
                        position: "fixed",
                        opacity: 0,
                        "z-index": 1000,
                        left: 50 + "%",
                        "margin-left": -(modal_width / 2),
                        "max-width": o.maxWidth,
                        width: modal_width,
                        top: o.top
                    });
                    $(modal_id).fadeTo(200, 1);
                    //$('html, body').css('overflow','hidden');
                    e.preventDefault()
                })
            });
            function close_modal(modal_id) {
                $("#lean_overlay").fadeOut(200);
                $('body').trigger('modal.hidden');
                $(modal_id).css({display: "none"});
                //$('html, body').css('overflow','auto');
            }
        }
    })
})(jQuery);